 ; Ŀ
 ;   Spk - Remove leading and trailing spaces from text and inserts.       
 ;   Spc - Remove all spaces from text and inserts.                        
 ;   Spak - Kill leading, trailing, and multiple inside spaces.            
 ;   Copyright 1993, 2005 by Rocket Software Ltd.                          
 ;   There is no suede made from fish hide.                                
 ; 

 ; Ŀ
 ;   Subroutine Ks - the crusher.                                          
 ;   Takes one argument, Progo - the name of the subroutine to call.       
 ;   Returns nothing.                                                      
 ; 
 (DEFUN KS (progo / ss num enam entt etype str nums esub)
 ; Ŀ
 ;   Get a selection set.                                                  
 ; 
  (if (setq ss (ssget '((-4 . "<or")
                        (-4 . "<and") (0 . "insert") (66 . 1) (-4 . "and>")
                        (0 . "text") (-4 . "or>"))))
      (progn
 ; Ŀ
 ;   Step through it.                                                      
 ; 
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq entt (entget enam))
                  (setq num (1+ num))
                  (setq etype (cdr (assoc 0 entt)))
 ; Ŀ
 ;   Text.                                                                 
 ; 
                  (cond ((= etype "TEXT")
                         (setq str (cdr (assoc 1 entt)))
                         (setq str (progo str))
                         (setq nums (cadr str))
                         (setq str (car str))
                         (if (null (zerop nums))
                             (progn
                                  (makr (cdr (assoc 10 entt)) nums)
                                  (entmod (subst (cons 1 str)
                                          (assoc 1 entt) entt)))))
 ; Ŀ
 ;   Inserts.                                                              
 ; 
                        ((= etype "INSERT")
                         (setq esub (entnext enam))
                         (while (/= "SEQEND" (cdr (assoc 0 (setq entt
                                                             (entget esub)))))
                                (setq str (cdr (assoc 1 entt)))
                                (setq str (progo str))
                                (setq nums (cadr str))
                                (setq str (car str))
                                (if (null (zerop nums))
                                    (progn
                                         (makr (cdr (assoc 10 entt)) nums)
                                         (entmod (subst (cons 1 str)
                                                        (assoc 1 entt) entt))))
                                (setq esub (entnext esub)))
                         (entupd enam))))))
 (princ))
 ; Ŀ
 ;   Subroutine Ks end.                                                    
 ; 

 ; Ŀ
 ;   Subroutine Lspace - kill leading and trailing spaces from a string.   
 ;   Takes one argument, a string.                                         
 ;   Returns a list: the modifiedp string and the no. of spaces removed.   
 ; 
 (DEFUN LSPACE (str / len monk)
  (setq monk 0)
  (while (and (/= str "") (= (substr str 1 1) " "))
         (setq monk (1+ monk))
         (setq str (substr str 2)))
  (while (and (/= str "") (= (substr str (setq len (strlen str))) " "))
         (setq monk (1+ monk))
         (setq str (substr str 1 (1- len))))
 (list str monk))
 ; Ŀ
 ;   Subroutine Lspace end.                                                
 ; 

 ; Ŀ
 ;   Mak: draw a set of temporary equally spaced diameters.                
 ;   Called by Mak.                                                        
 ;   Arguments: Pa, the arc centrepoint.                                   
 ;              Colo, the colour.                                          
 ;              Divs, the number of diameters to draw.                     
 ;              Rad, the radius.                                           
 ;   Calls nothing, returns nothing, doesn't do anything very permanent... 
 ; 
 (DEFUN MAK (pa col divs rad / anginc stangl pa0 pa1)
  (setq anginc (/ pi divs))
  (setq stangl 0)
  (repeat divs
          (setq pa0 (polar pa stangl rad))
          (setq pa1 (polar pa (+ stangl pi) rad))
          (grdraw pa0 pa1 col)
          (setq stangl (+ stangl anginc)))
 (princ))
 ; Ŀ
 ;   Mak end.                                                              
 ; 

 ; Ŀ
 ;   Makr: draw a marker - a set of diameters connected by arcs.           
 ;   Arguments: Pa, the centrepoint.                                       
 ;              Nums, the number of diameter lines to draw.                
 ;   Calls Mak and Pci.                                                    
 ;   Returns nothing.                                                      
 ; 
 (DEFUN MAKR (pa nums / colo rad)
  (setq colo 1)
  (setq rad (/ (getvar "viewsize") 45))
  (setq rad (/ (getvar "viewsize") 45))
  (mak pa colo nums rad)
  (pci pa rad nums 6 colo)
 (princ))
 ; Ŀ
 ;   Makr end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Pci - repeated arc maker.                                  
 ;   Called by Mak.                                                        
 ;   Arguments: Pa, the arc centrepoint.                                   
 ;              Radd, the radius.                                          
 ;              Segs, the number of arcs to draw.                          
 ;              Reps, the grdraw segments in each arc.                     
 ;              Colo, the colour.                                          
 ;   Calls nothing, returns nothing, doesn't do anything very permanent... 
 ; 
 (DEFUN PCI (pa radd segs reps colo / arcang bitang stangl bangle pa1 pa2)
  (setq arcang (/ pi segs))      ; angle in an arc
  (setq bitang (/ arcang reps))  ; individual dash chord angle
  (setq stangl 0)
  (repeat segs
         (setq bangle stangl)
         (repeat reps
                (setq pa1 (polar pa bangle radd))
                (setq bangle (+ bangle bitang))
                (setq pa2 (polar pa bangle radd))
                (grdraw pa1 pa2 colo))
         (setq stangl (+ stangl (* 2 arcang))))
 (princ))
 ; Ŀ
 ;   Pci end.                                                              
 ; 

 ; Ŀ
 ;   Spak - Remove leading and trailing and multiple internal spaces.      
 ;   Takes one argument, a string.                                         
 ;   Returns a list: the modified-p string and the no. of spaces removed.  
 ; 
 (defun spak (bstr / monk len pos bsub gnustr)
  (setq monk 0)
  (while (and (/= bstr "") (= (substr bstr 1 1) " "))
         (setq monk (1+ monk))
         (setq bstr (substr bstr 2)))
  (while (and (/= bstr "") (= (substr bstr (setq len (strlen bstr))) " "))
         (setq monk (1+ monk))
         (setq bstr (substr bstr 1 (1- len))))
  (setq pos 1)
  (setq len (strlen bstr))
  (while (and (>= len pos)
              (setq bsub (substr bstr pos 1)))
         (cond ((null gnustr)
                (setq gnustr bsub))
               ((or (/= (substr gnustr (strlen gnustr)) " ")
                    (/= bsub " "))
                (setq gnustr (strcat gnustr bsub)))
               (T
                (setq monk (1+ monk))))
         (setq pos (1+ pos)))
 (list (if gnustr gnustr "") monk))
 ; Ŀ
 ;   Spak end.                                                             
 ; 

 ; Ŀ
 ;   Spc - Remove all spaces from a string.                                
 ;   Takes one argument, a string.                                         
 ;   Returns a list: the modified-p string and the no. of spaces removed.  
 ; 
 (defun spc (bstr / monk len pos bsub gnustr)
  (setq monk 0)
  (setq pos 1)
  (setq gnustr "")
  (setq len (strlen bstr))
  (while (and (>= len pos)
              (setq bsub (substr bstr pos 1)))
         (if (/= bsub " ")
             (setq gnustr (strcat gnustr bsub))
             (setq monk (1+ monk)))
         (setq pos (1+ pos)))
 (list gnustr monk))
 ; Ŀ
 ;   Spc end.                                                              
 ; 

 ; Ŀ
 ;   Spc.                                                                  
 ; 
 (DEFUN C:SPC (/)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (ks spc)
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Spak.                                                                 
 ; 
 (DEFUN C:SPAK (/)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (ks spak)
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Spk.                                                                  
 ; 
 (DEFUN C:SPK (/)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (ks lspace)
  (command "undo" "end")
 (princ))